/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.frame;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.cmdhelpers.BpaFrameInfo;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.v50.R50Frame;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmFrameInstUpdater {
    private OmFrameMgr mFrameMgr = null;

    OmFrameInstUpdater(OmFrameMgr omFrameMgr) {
        this.mFrameMgr = omFrameMgr;
    }

    boolean update(BpaFrameInfo bpaFrameInfo) throws PIHscServerException, RException {
        boolean bl = false;
        if (((UnsignedInt8)this.mFrameMgr.getObject().getProperty(R50Frame.Index_State)).intValue() == 253) {
            int n = this.mFrameMgr.updateInterfaceCapability();
            if (n == 1) {
                return true;
            }
            this.mFrameMgr.bpcIsReady();
        }
        if (this.updateFrameInfo(bpaFrameInfo)) {
            bl = true;
        }
        if (this.updateFrameNum()) {
            bl = true;
        }
        if (this.updateFrameState()) {
            bl = true;
        }
        if (this.updateUserDefName()) {
            bl = true;
        }
        return bl;
    }

    boolean updateFrameInfo(BpaFrameInfo bpaFrameInfo) throws RException {
        return this.mFrameMgr.getObject().setProperty(R50Frame.Index_FrameType, (Object)bpaFrameInfo.getFrameType());
    }

    boolean updateFrameNum() throws PIHscServerException, RException {
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
        try {
            unsignedInt16 = this.mFrameMgr.getCmdHelper().getFrameNumber();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.mFrameMgr.getObject().setProperty(R50Frame.Index_FrameNumber, (Object)unsignedInt16);
    }

    boolean updateFrameState() throws PIHscServerException, RException {
        return this.mFrameMgr.getObject().setProperty(R50Frame.Index_State, (Object)this.mFrameMgr.getCmdHelper().getBpcState());
    }

    boolean updateUserDefName() throws PIHscServerException, RException {
        String string = this.mFrameMgr.getCmdHelper().getCecName();
        return this.mFrameMgr.getObject().setProperty(R50Frame.Index_UserDefinedName, (Object)string);
    }
}

